// DFGadget.h
//
// wrapper class for interface protocol of BeBar
//
// Copyright 1997 Thorsten Seitz

#ifndef DF_GADGET_H
#define DF_GADGET_H

#include "MThread.h"

enum { 
	DF_SET_BITMAP = '?SBM',
	DF_REQUEST_GADGET = '?RQG',
	DF_REMOVE_GADGET = '?RMG',
	DF_REGISTER_GADGET_MENU = '?RGM',
	
	DF_GADGET_ID = '?GID',
	DF_SHOW_GADGET_MENU = '?SGM',	
	DF_ERROR = '?ERR',
	DF_OK = '?OK!'
};


// class DFMenuThread

class DFGadget;

class
DFMenuThread : public MThread
{

public:
							DFMenuThread(
								DFGadget *gadget,
								BPoint where, 
								BRect sticky)
								 
								: MThread(), 
								fGadget(gadget), fWhere(where), 
								fSticky(sticky) {}
								
	virtual					~DFMenuThread() {}
							
	virtual long			Execute();
	
private:
			DFGadget		*fGadget;
			BPoint			fWhere;
			BRect			fSticky;
};


// class DFGadget

class
DFGadget : public BHandler
{

public:
						DFGadget(float smallWidth, float largeWidth);
	virtual				~DFGadget();
	
			long		ID() const { return fID; }
			
	virtual void		MessageReceived(BMessage *msg);
	
	virtual void		SetOffset(BPoint small, BPoint large);
	virtual void		SetBitmap(
							BBitmap *small, 
							BBitmap *large = NULL);
	virtual long		SetGadgetMenu(BPopUpMenu *menu);
			long		Update(bool invalidate = FALSE);
			
			bool		Lock() { return fLock.Lock(); }
			void		Unlock() { fLock.Unlock(); }
	
protected:

	virtual long 		RegisterMenu();
	virtual long		Connect();
	virtual long		SendMessage(BMessage *msg, 
							bool async = FALSE);
	
	long				fID;
	float				fSmallWidth, fLargeWidth;
	BPoint				fSmallOffset, fLargeOffset;
	BBitmap				*fSmallIcon, *fLargeIcon;
	BPopUpMenu			*fPopUpMenu;
	
private:
	
	BLocker				fLock;
	BMessenger			*fBar, *fGadget;
	bool				fMenuRunning;
	
friend class DFMenuThread;
};

#endif
